/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.io;

import com.google.common.collect.ImmutableSet;
import cz.insophy.inplan.util.io.TokenResolver;
import java.util.Map;

public class MapTokenResolver
implements TokenResolver {
    private final Map<String, String> mapping;

    public MapTokenResolver(Map<String, String> mapping) {
        this.mapping = mapping;
    }

    @Override
    public String resolveToken(String tokenName) {
        if (this.mapping == null) {
            return null;
        }
        return this.mapping.get(tokenName);
    }

    @Override
    public boolean isTokenResolved(String tokenName) {
        return this.mapping != null && this.mapping.containsKey(tokenName);
    }

    @Override
    public ImmutableSet<String> getAllKeys() {
        return ImmutableSet.copyOf(this.mapping.keySet());
    }
}

